# AirwavePBX v1.1.0 (Go Edition)

🚀 **Modern PBX System for Asterisk - Rebuilt with Go for Maximum Reliability**

AirwavePBX v1.1.0 represents a complete architectural transformation from the Node.js-based v1.0.x series to a robust Go-based single binary deployment model. This version eliminates the complex dependency chains and infrastructure requirements that caused issues in previous versions.

## 🎯 **Key Improvements Over v1.0.x**

### **Simplified Architecture**
- ✅ **Single Binary Deployment** - No Node.js, npm, or complex dependencies
- ✅ **Embedded SQLite Database** - No PostgreSQL setup or management required
- ✅ **Direct HTTPS Serving** - No Nginx reverse proxy complications
- ✅ **Atomic Updates** - Simple binary replacement for updates

### **Eliminated Pain Points**
- ❌ **No Database Authentication Issues** - Self-contained SQLite
- ❌ **No Node.js Version Conflicts** - Zero Node.js dependency
- ❌ **No Nginx Proxy Problems** - Direct TLS termination
- ❌ **No Complex Service Dependencies** - Minimal moving parts

### **Preserved Excellence**
- 🎨 **Liquid Glass Design System** - Complete Apple-inspired UI framework
- 🎭 **FontAwesome Pro (fap) Icons** - 3,325+ duotone SVG icons with dynamic theming
- 🔐 **JWT Authentication** - Modern security architecture
- 📱 **Responsive Design** - Mobile-optimized interface
- ⚙️ **Asterisk Integration** - Full AMI and configuration management

## 🏗️ **Architecture Overview**

```
┌─────────────────────────────────────────────────────────────────┐
│                    AirwavePBX v1.1.0 (Go)                      │
├─────────────────────────────────────────────────────────────────┤
│  🌐 HTTPS Server (Port 8443)                                   │
│  ├── 🎨 Liquid Glass Frontend (Embedded)                       │
│  ├── 🔌 REST API (Gin Framework)                               │
│  ├── 🗄️ SQLite Database (Embedded)                             │
│  └── 🎭 Dynamic fap Icon Serving                               │
├─────────────────────────────────────────────────────────────────┤
│  📞 Asterisk Integration (AMI)                                 │
│  ├── 🔧 Configuration Management                               │
│  ├── 📊 Real-time Statistics                                   │
│  ├── 📱 Extension Management                                   │
│  └── 📈 Call Monitoring                                        │
└─────────────────────────────────────────────────────────────────┘
```

## 📦 **Installation**

### **System Requirements**
- **OS**: Debian 12 (Bookworm) - Recommended
- **RAM**: 2GB minimum, 4GB recommended
- **Disk**: 5GB free space
- **Network**: Internet connection for downloads

### **Quick Installation**
```bash
# Download and extract
wget https://versions.airwavepbx.com/airwavepbx-1.1.0-go-linux-amd64.tar.gz
tar -xzf airwavepbx-1.1.0-go-linux-amd64.tar.gz
cd airwavepbx-1.1.0-go-linux-amd64

# Install
sudo ./install.sh

# Reboot for clean service startup
sudo reboot
```

### **Installation Options**
```bash
sudo ./install.sh           # Fresh installation
sudo ./install.sh --update  # Update existing installation
sudo ./install.sh --repair  # Repair installation issues
sudo ./install.sh --force   # Force clean installation
```

## 🛠️ **Management**

### **System Management Script**
```bash
# Interactive management menu
sudo ./airwavepbx.sh

# Command line options
sudo ./airwavepbx.sh --status    # Show system status
sudo ./airwavepbx.sh --start     # Start all services
sudo ./airwavepbx.sh --stop      # Stop all services
sudo ./airwavepbx.sh --restart   # Restart all services
sudo ./airwavepbx.sh --update    # Check and install updates
sudo ./airwavepbx.sh --backup    # Create system backup
```

### **Service Management**
```bash
# Systemd service control
sudo systemctl start airwavepbx    # Start AirwavePBX
sudo systemctl stop airwavepbx     # Stop AirwavePBX
sudo systemctl restart airwavepbx  # Restart AirwavePBX
sudo systemctl status airwavepbx   # Check status

# View logs
sudo journalctl -u airwavepbx -f   # Live logs
sudo journalctl -u asterisk -f     # Asterisk logs
```

## 🎨 **Design System**

### **Liquid Glass Framework**
- **Glass Morphism Effects** - Apple-inspired backdrop filters and transparency
- **Interactive Animations** - Smooth transitions and ripple effects
- **Dynamic Theming** - CSS custom properties for real-time color management
- **Responsive Layouts** - Mobile-first design principles

### **FontAwesome Pro (fap) Integration**
- **3,325+ Duotone Icons** - Complete FontAwesome Pro duotone collection
- **Dynamic Coloring** - Server-side SVG templating with color parameters
- **Context-Aware Theming** - Status-based icon coloring
- **High Performance** - Cached SVG serving with proper headers

### **Color System**
```css
/* Primary theme colors */
--primary: #2563eb
--secondary: #93c5fd
--success: #16a34a
--warning: #f59e0b
--danger: #dc2626
```

## 📊 **Features**

### **Core PBX Management**
- 📞 **Extension Management** - Create, configure, and manage SIP extensions
- 🌐 **Trunk Configuration** - Connect to SIP providers and carriers
- 📈 **Call Analytics** - Real-time call statistics and history
- 🔊 **Audio Management** - Voicemail, music on hold, and recordings

### **System Administration**
- 👥 **User Management** - Multi-user access with role-based permissions
- 🔐 **Security Features** - JWT authentication, SSL/TLS encryption
- 📋 **Configuration Management** - Web-based Asterisk configuration
- 📊 **System Monitoring** - Health checks and performance metrics

### **Advanced Features**
- 🔄 **Auto-Updates** - Integrated update system from versions.airwavepbx.com
- 💾 **Backup/Restore** - Automated backup creation and management
- 🔧 **Diagnostics** - Built-in troubleshooting and repair tools
- 📱 **Mobile Responsive** - Full functionality on mobile devices

## 🔧 **Configuration**

### **Environment Variables**
```bash
# Server Configuration
PORT=8443                          # HTTPS port
SSL_CERT=/etc/ssl/certs/airwavepbx.crt
SSL_KEY=/etc/ssl/private/airwavepbx.key

# Database (SQLite)
DB_PATH=/opt/airwavepbx/data/airwavepbx.db

# Asterisk Integration
ASTERISK_HOST=127.0.0.1             # AMI host
ASTERISK_PORT=5038                  # AMI port
ASTERISK_USER=airwaveami            # AMI username
ASTERISK_PASS=<generated>           # AMI password

# Security
JWT_SECRET=<generated>              # JWT signing secret
ADMIN_PASSWORD=<generated>          # Default admin password
```

### **File Locations**
```
/opt/airwavepbx/                   # Application directory
├── airwavepbx                     # Main binary
├── data/                          # SQLite database
└── .env                           # Configuration file

/etc/airwavepbx/                   # System configuration
/var/log/airwavepbx/               # Application logs
/var/backups/airwavepbx/           # System backups
/etc/ssl/certs/airwavepbx.crt      # SSL certificate
/etc/ssl/private/airwavepbx.key    # SSL private key
```

## 🚀 **Development**

### **Building from Source**
```bash
# Prerequisites
# - Go 1.21 or later
# - Git

# Clone and build
git clone <repository>
cd AirwavePBX-Go

# Run tests
./build.sh test

# Build binary and package
./build.sh

# Clean build directory
./build.sh clean
```

### **Project Structure**
```
AirwavePBX-Go/
├── cmd/airwavepbx/               # Main application
├── internal/                     # Internal packages
│   ├── api/                      # REST API routes
│   ├── config/                   # Configuration management
│   ├── database/                 # SQLite database layer
│   └── server/                   # HTTP server
├── assets/                       # Embedded frontend assets
│   ├── css/                      # Liquid Glass stylesheets
│   ├── js/                       # Frontend JavaScript
│   ├── images/                   # Logos and graphics
│   └── fap/duotone/              # FontAwesome Pro icons
├── install.sh                    # Installation script
├── airwavepbx.sh                 # Management script
└── build.sh                      # Build script
```

## 📈 **Version History**

### **v1.1.0 (Go Edition) - Current**
- 🔄 **Complete architectural rewrite** in Go
- 🗄️ **SQLite embedded database** - eliminated PostgreSQL dependency
- 🌐 **Direct HTTPS serving** - eliminated Nginx proxy
- 📦 **Single binary deployment** - eliminated Node.js dependency
- 🎨 **Preserved Liquid Glass design** - maintained beautiful UI
- 🎭 **Enhanced fap icon system** - server-side SVG templating
- 🔧 **Simplified installation** - reduced complexity by 80%

### **v1.0.34 (Node.js) - Previous**
- 🧠 Smart Asterisk detection and configuration recreation
- 🛡️ Bulletproof authentication and credential management
- 🔧 Enhanced installation with comprehensive failsafes
- 📊 Advanced diagnostic and repair tools

## 🆘 **Support**

### **Getting Help**
- 📖 **Documentation**: https://docs.airwavepbx.com
- 🐛 **Bug Reports**: https://github.com/airwavepbx/issues
- 💬 **Community**: https://community.airwavepbx.com

### **Troubleshooting**
```bash
# Run system diagnostics
sudo ./airwavepbx.sh

# Check service status
sudo systemctl status airwavepbx asterisk

# View logs
sudo journalctl -u airwavepbx -f

# Repair installation
sudo ./install.sh --repair
```

## 📄 **License**

Copyright (c) 2024 AirwavePBX Team. All rights reserved.

---

**🎉 AirwavePBX v1.1.0 (Go Edition) - Reliable, Beautiful, and Simple**